<div class="urc-frontend-wrapper">
    <div class="urc-frontend-header">
        <h2 class="urc-frontend-title"><?php echo esc_html($atts['title']); ?></h2>
        <div class="urc-frontend-branding">
            <span class="urc-powered-by">Powered by</span>
            <a href="https://foxco.net" target="_blank" rel="noopener noreferrer" class="urc-brand-link">
                <span class="urc-brand-name">Foxco.net</span>
            </a>
        </div>
    </div>
    
    <div class="urc-frontend-container">
        <div class="urc-frontend-input">
            <div class="urc-frontend-card">
                <div class="urc-frontend-tabs">
                    <button class="urc-frontend-tab-button active" data-tab="paste">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                        </svg>
                        Paste URLs
                    </button>
                    <button class="urc-frontend-tab-button" data-tab="upload">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M7 18a4.6 4.4 0 01 0 -9 5 4.5 0 01 11 2h1a3.5 3.5 0 01 0 7h-1"/>
                            <polyline points="9 15 12 12 15 15"/>
                            <path d="M12 12v9"/>
                        </svg>
                        Upload CSV
                    </button>
                </div>
                
                <!-- Paste URLs Tab -->
                <div id="urc-frontend-tab-paste" class="urc-frontend-tab-content active">
                    <div class="urc-frontend-form-group">
                        <label for="urc-frontend-url-input">Enter URLs (one per line):</label>
                        <textarea 
                            id="urc-frontend-url-input" 
                            class="urc-frontend-textarea" 
                            rows="12" 
                            placeholder="https://example.com/page1&#10;https://example.com/page2&#10;https://example.com/page3"
                        ></textarea>
                    </div>
                    <button id="urc-frontend-check-button" class="urc-frontend-button urc-frontend-button-primary">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="11" cy="11" r="8"/>
                            <path d="M21 21l-4.35-4.35"/>
                        </svg>
                        Check Redirects
                    </button>
                </div>
                
                <!-- Upload CSV Tab -->
                <div id="urc-frontend-tab-upload" class="urc-frontend-tab-content">
                    <div class="urc-frontend-form-group">
                        <label for="urc-frontend-csv-upload">Upload CSV file:</label>
                        <div class="urc-frontend-file-upload">
                            <input type="file" id="urc-frontend-csv-upload" accept=".csv" class="urc-frontend-file-input">
                            <label for="urc-frontend-csv-upload" class="urc-frontend-file-label">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M7 18a4.6 4.4 0 01 0 -9 5 4.5 0 01 11 2h1a3.5 3.5 0 01 0 7h-1"/>
                                    <polyline points="9 15 12 12 15 15"/>
                                    <path d="M12 12v9"/>
                                </svg>
                                <span class="urc-file-label-text">Choose CSV file</span>
                                <span class="urc-file-label-selected"></span>
                            </label>
                        </div>
                        <p class="urc-frontend-description">CSV should contain URLs in the first column</p>
                    </div>
                    <button id="urc-frontend-upload-button" class="urc-frontend-button urc-frontend-button-primary">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/>
                            <polyline points="17 8 12 3 7 8"/>
                            <line x1="12" y1="3" x2="12" y2="15"/>
                        </svg>
                        Process CSV
                    </button>
                </div>
            </div>
        </div>
        
        <div class="urc-frontend-results">
            <div class="urc-frontend-card">
                <div class="urc-frontend-results-header">
                    <h3>Results</h3>
                    <button id="urc-frontend-download-csv" class="urc-frontend-button urc-frontend-button-secondary" style="display: none;">
                        <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M21 15v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4"/>
                            <polyline points="7 10 12 15 17 10"/>
                            <line x1="12" y1="15" x2="12" y2="3"/>
                        </svg>
                        Download CSV
                    </button>
                </div>
                
                <div id="urc-frontend-progress" class="urc-frontend-progress" style="display: none;">
                    <div class="urc-frontend-progress-bar">
                        <div class="urc-frontend-progress-fill"></div>
                    </div>
                    <p class="urc-frontend-progress-text">Checking redirects... <span id="urc-frontend-progress-count">0/0</span></p>
                </div>
                
                <div id="urc-frontend-results" class="urc-frontend-results-content">
                    <div class="urc-frontend-empty-state">
                        <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path d="M10 13a5 5 0 007.54.54l3-3a5 5 0 00-7.07-7.07l-1.72 1.71"/>
                            <path d="M14 11a5 5 0 00-7.54-.54l-3 3a5 5 0 007.07 7.07l1.71-1.71"/>
                        </svg>
                        <p>Enter URLs or upload a CSV file to get started.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
