# Foxco URL Redirect Checker - WordPress Plugin

A WordPress plugin by **[Foxco.net](https://foxco.net)** that allows you to check URL redirects by pasting a list of URLs or uploading a CSV file. The results show the original URL in column A and the final destination URL in column B.

## Features

- ✅ **Paste URLs**: Copy and paste multiple URLs (one per line)
- ✅ **Upload CSV**: Upload a CSV file containing URLs
- ✅ **Frontend Shortcode**: Display the redirect checker on any page or post
- ✅ **Real-time Progress**: Track the progress of URL checking
- ✅ **Detailed Results**: View original URL, final destination, redirect status, and HTTP status codes
- ✅ **Download Results**: Export results as a CSV file
- ✅ **Summary Statistics**: See total URLs, redirects, no redirects, and errors at a glance
- ✅ **Foxco.net Branding**: Beautiful gradient design with Foxco.net branding
- ✅ **Dark Mode Support**: Optional dark theme for frontend display
- ✅ **Clean UI**: Modern, responsive interface
- ✅ **No Login Required**: Frontend works for all visitors

## Installation

### Method 1: Manual Installation

1. Download the `url-redirect-checker` folder
2. Upload it to your WordPress site's `/wp-content/plugins/` directory
3. Go to WordPress Admin → Plugins
4. Find "Foxco URL Redirect Checker" and click "Activate"

### Method 2: ZIP Installation

1. Compress the `url-redirect-checker` folder into a ZIP file
2. Go to WordPress Admin → Plugins → Add New
3. Click "Upload Plugin"
4. Choose the ZIP file and click "Install Now"
5. Click "Activate Plugin"

## Usage

### Admin Interface

After activation, go to WordPress Admin and look for **Redirect Checker** in the main menu (with a link icon).

#### Method 1: Paste URLs

1. Click on the "Paste URLs" tab
2. Enter your URLs, one per line, in the textarea
3. Click "Check Redirects"
4. Wait for the results to appear
5. (Optional) Click "Download CSV" to export the results

Example input:
```
https://example.com/old-page
https://example.com/another-page
https://example.com/redirect-me
```

#### Method 2: Upload CSV

1. Click on the "Upload CSV" tab
2. Prepare a CSV file with URLs in the first column (header optional)
3. Click "Choose File" and select your CSV
4. Click "Process CSV"
5. Wait for the results to appear
6. (Optional) Click "Download CSV" to export the results

Example CSV format:
```csv
URL
https://example.com/page1
https://example.com/page2
https://example.com/page3
```

### Frontend Shortcode

Display the redirect checker on any page or post using the shortcode:

#### Basic Usage
```
[foxco_redirect_checker]
```

#### With Custom Title
```
[foxco_redirect_checker title="Check Your Redirects"]
```

#### With Dark Theme
```
[foxco_redirect_checker theme="dark"]
```

#### Full Example
```
[foxco_redirect_checker title="URL Redirect Tool" theme="light"]
```

**Shortcode Parameters:**
- `title` - Custom title for the tool (default: "URL Redirect Checker")
- `theme` - Color theme: "light" or "dark" (default: "light")

### Frontend Features

The frontend shortcode provides:
- Beautiful Foxco.net branded design with gradient colors
- Same functionality as admin: paste URLs or upload CSV
- Real-time progress tracking with animated progress bar
- Responsive design that works on all devices
- Download results as CSV
- Summary statistics dashboard
- Clean, modern interface
- No login required - works for all visitors

## Understanding the Results

The results table shows:

- **Column A (Original URL)**: The URL you submitted for checking
- **Column B (Final Destination URL)**: The URL after following all redirects
- **Status**: 
  - 🔴 **Redirect**: The URL redirects to a different location
  - 🟢 **No Redirect**: The URL does not redirect
  - 🟡 **Error**: An error occurred while checking the URL
- **Code**: HTTP status code (200, 301, 302, 404, etc.)

### Summary Statistics

At the top of the results, you'll see:
- **Total URLs**: Number of URLs checked
- **Redirects**: Number of URLs that redirect
- **No Redirect**: Number of URLs that don't redirect
- **Errors**: Number of URLs that encountered errors

## Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher
- jQuery (included with WordPress)

## Technical Details

### File Structure

```
url-redirect-checker/
├── url-redirect-checker.php  (Main plugin file)
├── assets/
│   ├── css/
│   │   ├── admin.css         (Admin styles)
│   │   ├── frontend.css      (Frontend styles with Foxco branding)
│   │   └── index.php         (Security file)
│   └── js/
│       ├── admin.js          (Admin JavaScript)
│       ├── frontend.js       (Frontend JavaScript)
│       └── index.php         (Security file)
├── sample-urls.csv           (Sample CSV file)
├── index.php                 (Security file)
└── README.md                 (This file)
```

### How It Works

1. The plugin uses WordPress's built-in `wp_remote_get()` function to make HTTP requests
2. It follows redirects automatically (up to 10 redirects)
3. Results are processed via AJAX for a smooth user experience
4. No data is stored in the database - everything is processed in real-time
5. CSV export is generated client-side using JavaScript
6. Frontend and admin interfaces share the same backend logic

### Security Features

- Nonce verification for all AJAX requests
- URL validation and sanitization
- XSS protection with proper escaping
- CSRF protection
- No stored data (privacy-friendly)
- Frontend accessible to all users (no capability checks for frontend)

### Foxco.net Branding

This plugin is proudly powered by **Foxco.net**. The branding includes:
- Gradient color scheme (purple/blue gradients)
- Foxco.net logo link in both admin and frontend
- Modern, professional design
- Customizable via CSS if needed

## Troubleshooting

### URLs not being checked

- Make sure the URLs are properly formatted (include http:// or https://)
- Check if your server can make outbound HTTP requests
- Some servers have restrictions on external HTTP requests

### Timeout errors

- The plugin has a 10-second timeout per URL
- If you're checking many URLs, be patient
- Consider checking URLs in smaller batches

### CSV upload not working

- Ensure your CSV file has URLs in the first column
- Check file size limits (WordPress default is 2MB)
- Make sure the file has a .csv extension

### Shortcode not displaying

- Make sure the plugin is activated
- Check if your theme supports shortcodes
- Try adding the shortcode in a text/code block (not paragraph block in Gutenberg)

## Customization

### Custom CSS

You can customize the appearance by adding custom CSS to your theme:

```css
/* Change the gradient colors */
.foxco-redirect-checker-container .foxco-brand {
    background: linear-gradient(135deg, #your-color1 0%, #your-color2 100%);
}

/* Customize button colors */
.foxco-button-primary {
    background: linear-gradient(135deg, #your-color1 0%, #your-color2 100%);
}
```

## Support

For issues, questions, or feature requests, please visit [Foxco.net](https://foxco.net).

## License

GPL v2 or later

## Credits

Developed by **[Foxco.net](https://foxco.net)**

## Version History

### Version 1.0.0
- Initial release
- Admin interface with paste URLs and CSV upload
- Frontend shortcode with `[foxco_redirect_checker]`
- Real-time progress tracking
- CSV export of results
- Summary statistics
- Foxco.net branding
- Dark mode support for frontend
- Responsive design
- No login required for frontend use
