# Quick Start Guide - Foxco URL Redirect Checker

## 🚀 5-Minute Installation

### Step 1: Download
Download the plugin ZIP file: `foxco-redirect-checker-v1.0.0.zip`

### Step 2: Install
1. Go to WordPress Admin
2. Navigate to **Plugins → Add New**
3. Click **Upload Plugin**
4. Click **Choose File** and select the ZIP
5. Click **Install Now**
6. Click **Activate Plugin**

✅ **Done!** The plugin is now active.

---

## 💼 Using in WordPress Admin

### Access the Tool
1. Look for **Redirect Checker** in the left sidebar menu (link icon)
2. Click to open the redirect checker

### Check URLs - Method 1: Paste
1. Click the **Paste URLs** tab
2. Enter URLs (one per line)
3. Click **Check Redirects**
4. View results
5. (Optional) Click **Download CSV**

### Check URLs - Method 2: Upload CSV
1. Click the **Upload CSV** tab
2. Click **Choose File** and select your CSV
3. Click **Process CSV**
4. View results
5. (Optional) Click **Download CSV**

---

## 🌐 Using on Your Website (Frontend)

### Add to Any Page or Post

**Option 1: Basic Shortcode**
```
[foxco_redirect_checker]
```

**Option 2: With Custom Title**
```
[foxco_redirect_checker title="Check Your Redirects"]
```

**Option 3: Dark Theme**
```
[foxco_redirect_checker theme="dark"]
```

### How to Add Shortcode

**In Gutenberg (Block Editor):**
1. Edit your page/post
2. Click **+** to add a block
3. Search for "Shortcode"
4. Add the Shortcode block
5. Paste: `[foxco_redirect_checker]`
6. Click **Update** or **Publish**

**In Classic Editor:**
1. Edit your page/post
2. Paste the shortcode directly in the editor
3. Click **Update** or **Publish**

---

## 📋 CSV File Format

Your CSV file should have URLs in the first column:

```csv
URL
https://example.com/page1
https://example.com/page2
https://example.com/page3
```

Or without header:
```csv
https://example.com/page1
https://example.com/page2
https://example.com/page3
```

**Sample CSV file included:** `sample-urls.csv`

---

## 🎯 Common Use Cases

### SEO Analysis
Check all your site's redirects after a migration
```
[foxco_redirect_checker title="Post-Migration Redirect Checker"]
```

### Client Services
Offer redirect checking as a free tool
```
[foxco_redirect_checker title="Free SEO Tool - Redirect Checker"]
```

### Internal Use
Use the admin interface for quick checks

---

## ⚙️ Settings & Configuration

**No settings required!** The plugin works out of the box.

### Optional Customization
You can customize colors by adding CSS to your theme:

```css
/* Change the gradient */
.foxco-brand {
    background: linear-gradient(135deg, #your-color1 0%, #your-color2 100%);
}
```

---

## 🆘 Troubleshooting

### Shortcode Displays as Text
**Solution:** Make sure you're using a Shortcode block in Gutenberg, not a paragraph block.

### Plugin Not Showing in Menu
**Solution:** Make sure you activated the plugin after installation.

### URLs Timing Out
**Solution:** Check fewer URLs at once (the plugin has a 10-second timeout per URL).

### CSV Won't Upload
**Solution:** 
- Check file size (max 2MB by default)
- Make sure file extension is .csv
- Ensure URLs are in the first column

---

## 📱 Mobile Friendly

The plugin is fully responsive:
- ✅ Works on desktop computers
- ✅ Works on tablets
- ✅ Works on smartphones
- ✅ Touch-friendly interface

---

## 🔒 Privacy & Security

- ✅ No data stored in database
- ✅ All processing happens in real-time
- ✅ AJAX security with nonces
- ✅ XSS and CSRF protection
- ✅ No tracking or analytics

---

## 📚 Additional Resources

**Included Documentation:**
- `README.md` - Complete documentation
- `SHORTCODE-EXAMPLES.md` - More shortcode examples
- `FEATURES.md` - Full feature list
- `sample-urls.csv` - Example CSV file

**Need Help?**
Visit [Foxco.net](https://foxco.net) for support

---

## 🌟 What You Get

### Admin Interface
- Check redirects from WordPress admin
- Two input methods (paste or upload)
- Real-time progress tracking
- Download results as CSV
- Summary statistics

### Frontend Shortcode
- Add to any page or post
- Works for all visitors (no login required)
- Beautiful Foxco.net branding
- Dark mode option
- Mobile responsive

### Features
- Unlimited URL checking
- HTTP status codes
- Redirect chain detection
- Error reporting
- CSV import/export

---

## ✨ Quick Tips

1. **For best results:** Use full-width pages for the shortcode
2. **Save time:** Upload CSV files for bulk checking
3. **SEO use:** Check after site migrations or URL changes
4. **Client services:** Add to a public page as a free tool
5. **Dark sites:** Use `theme="dark"` parameter

---

## 🎉 You're Ready!

Start checking redirects in:
- **Admin:** WordPress Admin → Redirect Checker
- **Frontend:** Add `[foxco_redirect_checker]` to any page

---

Powered by **[Foxco.net](https://foxco.net)** 🚀

Thank you for using Foxco URL Redirect Checker!
