# Foxco LiteSpeed/QUIC Cleanup Plugin

A comprehensive WordPress plugin to remove all traces of LiteSpeed Cache and QUIC services from your WordPress installation.

## Features

This plugin thoroughly cleans:

- **Database Options** - All LiteSpeed and QUIC related options
- **Post Meta** - LiteSpeed metadata attached to posts
- **User Meta** - User-specific LiteSpeed settings
- **Transients** - Temporary cached data
- **Cron Jobs** - Scheduled LiteSpeed tasks
- **.htaccess Rules** - Server configuration directives
- **Cache Directories** - Physical cache file storage
- **Configuration Files** - LiteSpeed config files
- **wp-config.php Constants** - Hardcoded LiteSpeed settings

## Installation

### Method 1: Upload via WordPress Admin

1. Download the plugin files
2. Create a ZIP file containing:
   - `foxco-litespeed-cleanup.php`
   - `assets/admin.css`
3. Go to WordPress Admin > Plugins > Add New > Upload Plugin
4. Upload the ZIP file and activate

### Method 2: FTP/SFTP Upload

1. Upload the entire plugin folder to `/wp-content/plugins/foxco-litespeed-cleanup/`
2. Ensure the directory structure is:
   ```
   /wp-content/plugins/foxco-litespeed-cleanup/
   ├── foxco-litespeed-cleanup.php
   └── assets/
       └── admin.css
   ```
3. Go to WordPress Admin > Plugins and activate "Foxco LiteSpeed/QUIC Cleanup"

## Usage

1. After activation, go to **Tools > LiteSpeed Cleanup** in your WordPress admin
2. Review the list of items that will be cleaned
3. Click **"Run Cleanup Now"**
4. Confirm the action (this cannot be undone!)
5. Review the cleanup results log

## What Gets Cleaned

### Database Patterns
- `litespeed%`
- `lscache%`
- `lscwp%`
- `quic%`
- `_litespeed%`
- `_lscache%`

### File Locations
- `/wp-content/cache/litespeed/`
- `/wp-content/cache/lscache/`
- `/wp-content/litespeed/`
- `/wp-content/lscache/`
- `.htaccess` (LiteSpeed rules removed)
- `wp-config.php` (LiteSpeed constants removed)
- `.litespeed_conf.dat`
- `lscache.conf`

### Cron Jobs
All scheduled tasks containing:
- `litespeed`
- `lscache`
- `lscwp`
- `quic`

## Important Notes

⚠️ **Backup First**: Always create a complete backup before running this cleanup

⚠️ **Cannot Be Undone**: Once cleanup is complete, the data cannot be recovered

⚠️ **File Permissions**: The plugin requires write access to:
- WordPress database
- `.htaccess` file
- `wp-config.php` file
- Cache directories

## After Cleanup

After running the cleanup, you should:

1. **Deactivate the plugin** (or leave it for future use)
2. **Clear any CDN caches** if you use a CDN
3. **Test your website** to ensure everything works correctly
4. **Check .htaccess** manually to verify LiteSpeed rules are gone
5. **Review wp-config.php** to confirm constants are removed

## Troubleshooting

### "File not writable" warnings

If you see warnings about files not being writable:
- Check file permissions (should be 644 for files, 755 for directories)
- Manually edit `.htaccess` and `wp-config.php` to remove LiteSpeed references
- Contact your hosting provider for assistance

### Cleanup doesn't remove everything

Some hosting environments may have:
- Server-level LiteSpeed configurations
- Read-only file systems
- Protected configuration files

Contact your hosting provider to remove server-level LiteSpeed configurations.

## System Requirements

- WordPress 5.0 or higher
- PHP 7.0 or higher
- MySQL 5.6 or higher
- Administrator access

## Changelog

### Version 1.0.0
- Initial release
- Complete database cleanup
- File system cleanup
- Configuration file cleanup
- Admin interface with results logging

## Support

For support, please contact:
- Website: https://foxco.net
- Plugin issues: Review the cleanup log for specific errors

## License

GPL v2 or later
https://www.gnu.org/licenses/gpl-2.0.html

---

**Developed by Foxco.net** - WordPress Performance & Optimization Experts
